import { axios } from '@/lib/axios';
import { ExtractFnReturnType, QueryConfig } from '@/lib/react-query';
import { useQuery } from 'react-query';
import { Notification } from '@/types/Notification';
import { ApiResponse } from '@/types';

export const getNotifications = async (
  apiData: string | null = null
): Promise<ApiResponse<Notification[]>> => {
  if (apiData === 'admins') {
    return axios.get('/admin-api/admin-notifications');
  } else {
    return axios.get('/customer-api/customer-notifications');
  }
};
type QueryFnType = typeof getNotifications;

type UseNotificationOptions = {
  config?: QueryConfig<QueryFnType>;
  apiData: string;
};

export const useNotifications = ({ config, apiData }: UseNotificationOptions = { apiData: '' }) => {
  return useQuery<ExtractFnReturnType<QueryFnType>>({
    ...config,
    queryKey: ['notifications'],
    queryFn: () => getNotifications(apiData),
  });
};
